<?php

namespace App\Http\Controllers\Frontend;

use App\Services\AnalyticsService;
use App\Http\Controllers\Controller;

class LandingpageController extends Controller
{
   
    protected $analyticsService;

    // Lakukan Dependency Injection (DI) untuk Analytics Service
    public function __construct(AnalyticsService $analyticsService)
    {
        $this->analyticsService = $analyticsService;
    }

    /**
     * Halaman Utama (Home)
     */
    public function home(Request $request)
    {
        // 1. Rekam Kunjungan
        $this->analyticsService->recordVisit($request);

        // 2. Logika Utama
        $services = Service::all();
        $links = Link::all();
        
        return view('frontend.welcome', compact('services', 'links'));
    }

    /**
     * Halaman Works (Daftar Karya)
     */
    public function works(Request $request)
    {
        $this->analyticsService->recordVisit($request);

        $works = Work::all();
        return view('frontend.works', compact('works'));
    }

    /**
     * Halaman Works Show (Jika ini adalah halaman detail, perlu parameter slug/id)
     * Dibiarkan seperti ini sesuai rute lama, tapi disarankan direvisi.
     */
    public function worksShow(Request $request)
    {
        $this->analyticsService->recordVisit($request);
        
        $works = Work::all();
        return view('frontend.works', compact('works'));
    }

    /**
     * Halaman Labs (Eksperimen)
     */
    public function labs(Request $request)
    {
        $this->analyticsService->recordVisit($request);

        $experiments = Experiment::all();
        return view('frontend.labs', compact('experiments'));
    }

    /**
     * Halaman Labs Show (Dibiarkan seperti rute lama)
     */
    public function labsShow(Request $request)
    {
        $this->analyticsService->recordVisit($request);
        
        return view('frontend.labs');
    }

    /**
     * Halaman Insights (Blog/Tulisan)
     */
    public function insights(Request $request)
    {
        $this->analyticsService->recordVisit($request);

        $insights = Insight::all();
        return view('frontend.insights', compact('insights'));
    }

    /**
     * Halaman Daftar Services
     */
    public function services(Request $request)
    {
        $this->analyticsService->recordVisit($request);

        $services = Service::all();
        return view('frontend.services', compact('services'));
    }

    /**
     * Halaman Pieces Categories (Daftar Kategori Model 3D)
     */
    public function piecesCategories(Request $request)
    {
        $this->analyticsService->recordVisit($request);

        $categories = Piece::distinct()->pluck('category');
        return view('frontend.pieces.list', compact('categories'));
    }

    /**
     * Halaman Pieces Show By Category (Menampilkan Model per Kategori)
     */
    public function piecesShowByCategory(Request $request, string $category)
    {
        $this->analyticsService->recordVisit($request);

        $pieces = Piece::where('category', $category)->orderBy('title')->get();
        return view('frontend.pieces.view', compact('pieces', 'category'));
    }
}