<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class DashboardAuthenticated
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Jika sesi 'logged_in' TIDAK ADA atau TIDAK SAMA DENGAN TRUE
        if (!session('logged_in')) {
            // Arahkan ke halaman login
            return redirect()->route('access');
        }

        // Jika sudah login, lanjutkan permintaan
        return $next($request);
    }
}
