<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class DashboardGuest
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Jika sesi 'logged_in' ADA dan SAMA DENGAN TRUE
        if (session('logged_in')) {
            // Arahkan ke halaman dashboard (home)
            return redirect()->route('dashboard.home');
        }

        // Jika belum login, lanjutkan ke halaman login
        return $next($request);
    }
}
