<?php

use Illuminate\Foundation\Application;
use App\Http\Middleware\DashboardProtected;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use App\Http\Middleware\CustomDashboardAuth; // Import middleware kustom Anda

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->alias([
            'dashboard.auth' => \App\Http\Middleware\DashboardAuthenticated::class,
            'dashboard.guest' => \App\Http\Middleware\DashboardGuest::class,
        ]);

        // Anda juga bisa menambahkan middleware ke grup 'web',
        // yang akan berlaku untuk semua rute web secara default.
        // Contoh:
        // $middleware->web(append: [
        //     \App\Http\Middleware\AddSomeHeader::class,
        // ]);

    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();

