<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pieces', function (Blueprint $table) {
            $table->id();
            $table->string('category');
            $table->string('title');
            $table->json('description'); // Menyimpan array of objects sebagai JSON
            $table->string('model3d')->nullable(); // URL model 3D
            $table->timestamps();
        });

        // Data koleksi
        $pieces = [
            [
                'category' => 'Technology',
                'title' => 'Vintage Gaming Console',
                'description' => json_encode([
                    [
                        'title' => 'Retro Fun',
                        'content' => 'This old console represents countless hours of childhood fun. The simple graphics and challenging gameplay taught me patience and problem-solving long before I started coding.',
                        'transform' => ['rotation' => ['x' => 0.2, 'y' => 0.5, 'z' => 0.1]],
                        'details' => [
                            ['image' => 'https://tse2.mm.bing.net/th/id/OIP.FV3Mvgw4VezuNh9j4DlYMgHaEo?r=0&rs=1&pid=ImgDetMain&o=7&rm=3', 'text' => 'The iconic controller.', 'position' => ['x' => 200, 'y' => 50]],
                            ['image' => 'https://tse2.mm.bing.net/th/id/OIP.FV3Mvgw4VezuNh9j4DlYMgHaEo?r=0&rs=1&pid=ImgDetMain&o=7&rm=3', 'text' => 'The cartridge slot.', 'position' => ['x' => 450, 'y' => 120]]
                        ]
                    ],
                    [
                        'title' => 'A Lesson in History',
                        'content' => 'It’s a reminder of how far technology has come, from pixelated screens to hyper-realistic graphics. It’s the foundation of my love for technology.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 1.5, 'z' => 0.0]],
                        'details' => []
                    ]
                ]),
                'model3d' => '/models/game-console.glb',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category' => 'Technology',
                'title' => 'Old Laptop',
                'description' => json_encode([
                    [
                        'title' => 'My First Computer',
                        'content' => 'This clunky laptop was where I wrote my very first line of code. It’s a testament to the beginning of my career and the countless late nights I spent learning.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 0.0, 'z' => 0.0]],
                        'details' => [
                            ['image' => 'https://tse2.mm.bing.net/th/id/OIP.FV3Mvgw4VezuNh9j4DlYMgHaEo?r=0&rs=1&pid=ImgDetMain&o=7&rm=3', 'text' => 'The worn-out keyboard.', 'position' => ['x' => 180, 'y' => 40]]
                        ]
                    ],
                    [
                        'title' => 'A Digital Time Capsule',
                        'content' => 'It holds old projects and documents that chronicle my growth as a developer. It may be slow now, but it’s a priceless piece of my journey.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 1.0, 'z' => 0.0]],
                        'details' => []
                    ]
                ]),
                'model3d' => '/models/old-laptop.glb',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category' => 'Books',
                'title' => 'Vintage Science Book',
                'description' => json_encode([
                    [
                        'title' => 'Source of Curiosity',
                        'content' => 'A book I found in a second-hand shop. Its yellowed pages and hand-drawn illustrations sparked my curiosity for science and how the world works.',
                        'transform' => ['rotation' => ['x' => 0.3, 'y' => -0.5, 'z' => 0.2]],
                        'details' => [
                            ['image' => 'https://tse2.mm.bing.net/th/id/OIP.FV3Mvgw4VezuNh9j4DlYMgHaEo?r=0&rs=1&pid=ImgDetMain&o=7&rm=3', 'text' => 'The classic cover.', 'position' => ['x' => 200, 'y' => 30]]
                        ]
                    ],
                    [
                        'title' => 'Foundation of Knowledge',
                        'content' => 'This book is a tangible reminder that even in the digital age, the foundation of knowledge often comes from simple, well-written sources.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 1.0, 'z' => 0.0]],
                        'details' => []
                    ],
                    [
                        'title' => 'The Story Within',
                        'content' => 'Each page holds a new discovery. The tactile experience of turning a page and feeling the aged paper is a simple pleasure.',
                        'transform' => ['rotation' => ['x' => -0.1, 'y' => 2.5, 'z' => 0.0]],
                        'details' => [
                            ['image' => 'https://tse2.mm.bing.net/th/id/OIP.FV3Mvgw4VezuNh9j4DlYMgHaEo?r=0&rs=1&pid=ImgDetMain&o=7&rm=3', 'text' => 'A hand-drawn illustration.', 'position' => ['x' => 100, 'y' => 150]]
                        ]
                    ]
                ]),
                'model3d' => '/models/science-book.glb',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category' => 'Art',
                'title' => 'Sketchbook',
                'description' => json_encode([
                    [
                        'title' => 'My Creative Space',
                        'content' => 'This is where I sketch ideas for websites, apps, and even characters. It’s the physical manifestation of my imagination and a safe place for my creative thoughts.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 0.0, 'z' => 0.0]],
                        'details' => [
                            ['image' => 'https://tse2.mm.bing.net/th/id/OIP.FV3Mvgw4VezuNh9j4DlYMgHaEo?r=0&rs=1&pid=ImgDetMain&o=7&rm=3', 'text' => 'The messy pages.', 'position' => ['x' => 50, 'y' => 70]]
                        ]
                    ],
                    [
                        'title' => 'A Journey in Pages',
                        'content' => 'It’s more than just a book; it’s a living record of my artistic development. Each page tells a story of an idea being born.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 1.0, 'z' => 0.0]],
                        'details' => []
                    ]
                ]),
                'model3d' => '/models/sketchbook.glb',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category' => 'Music',
                'title' => 'Acoustic Guitar',
                'description' => json_encode([
                    [
                        'title' => 'The Sound of a Story',
                        'content' => 'My trusty acoustic guitar. Its sound has accompanied me through happy moments and somber reflections. It’s my go-to for unwinding and creative expression.',
                        'transform' => ['rotation' => ['x' => -0.2, 'y' => 0.5, 'z' => 0.1]],
                        'details' => [
                            ['image' => 'https://tse2.mm.bing.net/th/id/OIP.FV3Mvgw4VezuNh9j4DlYMgHaEo?r=0&rs=1&pid=ImgDetMain&o=7&rm=3', 'text' => 'The strings and fretboard.', 'position' => ['x' => 100, 'y' => 20]],
                            ['image' => 'https://tse2.mm.bing.net/th/id/OIP.FV3Mvgw4VezuNh9j4DlYMgHaEo?r=0&rs=1&pid=ImgDetMain&o=7&rm=3', 'text' => 'The wooden body.', 'position' => ['x' => 300, 'y' => 150]]
                        ]
                    ],
                    [
                        'title' => 'My Personal Sanctuary',
                        'content' => 'Playing it helps me escape the stresses of daily life. It’s a simple joy that has stayed with me for years.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 1.5, 'z' => 0.0]],
                        'details' => []
                    ]
                ]),
                'model3d' => '/models/acoustic-guitar.glb',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category' => 'Home',
                'title' => 'Desk Lamp',
                'description' => json_encode([
                    [
                        'title' => 'A Beacon of Focus',
                        'content' => 'This simple lamp has illuminated countless coding sessions and design projects. Its warm light helps me stay focused and is a comforting presence on my desk.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 0.0, 'z' => 0.0]],
                        'details' => [
                            ['image' => 'https://tse2.mm.bing.net/th/id/OIP.FV3Mvgw4VezuNh9j4DlYMgHaEo?r=0&rs=1&pid=ImgDetMain&o=7&rm=3', 'text' => 'The movable head.', 'position' => ['x' => 150, 'y' => 100]]
                        ]
                    ]
                ]),
                'model3d' => '/models/desk-lamp.glb',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category' => 'Hobbies',
                'title' => 'Running Shoes',
                'description' => json_encode([
                    [
                        'title' => 'My Path to Clarity',
                        'content' => 'These shoes have carried me through countless miles of running. They are not just for exercise; they are my way of clearing my mind and finding inspiration outside.',
                        'transform' => ['rotation' => ['x' => 0.1, 'y' => 0.2, 'z' => -0.1]],
                        'details' => [
                            ['image' => 'https://tse2.mm.bing.net/th/id/OIP.FV3Mvgw4VezuNh9j4DlYMgHaEo?r=0&rs=1&pid=ImgDetMain&o=7&rm=3', 'text' => 'The worn-out sole.', 'position' => ['x' => 200, 'y' => 10]]
                        ]
                    ],
                    [
                        'title' => 'More Than Just Gear',
                        'content' => 'They represent my commitment to physical and mental well-being, proving that balance is key to a productive life.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 1.0, 'z' => 0.0]],
                        'details' => []
                    ]
                ]),
                'model3d' => '/models/running-shoes.glb',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category' => 'Gadget',
                'title' => 'Smartwatch',
                'description' => json_encode([
                    [
                        'title' => 'My Digital Companion',
                        'content' => 'This smartwatch keeps me connected and on track throughout the day. It’s a subtle reminder to be more mindful of my health and time.',
                        'transform' => ['rotation' => ['x' => 0.3, 'y' => -0.5, 'z' => 0.0]],
                        'details' => [
                            ['image' => 'https://tse2.mm.bing.net/th/id/OIP.FV3Mvgw4VezuNh9j4DlYMgHaEo?r=0&rs=1&pid=ImgDetMain&o=7&rm=3', 'text' => 'The sleek display.', 'position' => ['x' => 10, 'y' => 50], 'pointSize' => 10]
                        ]
                    ],
                    [
                        'title' => 'A Tool for Productivity',
                        'content' => 'From tracking my workouts to managing notifications, it’s a tiny gadget that has a big impact on my daily productivity.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 1.5, 'z' => 0.0]],
                        'details' => []
                    ],
                    [
                        'title' => 'The Heart of the Watch',
                        'content' => 'Inside, a small chip processes everything, from heart rate to notifications, a testament to modern micro-engineering.',
                        'transform' => ['rotation' => ['x' => 0.5, 'y' => 0.0, 'z' => 0.0]],
                        'details' => [
                            ['image' => 'https://tse2.mm.bing.net/th/id/OIP.FV3Mvgw4VezuNh9j4DlYMgHaEo?r=0&rs=1&pid=ImgDetMain&o=7&rm=3', 'text' => 'The sensor array.', 'position' => ['x' => 150, 'y' => 200], 'pointSize' => 15]
                        ]
                    ]
                ]),
                'model3d' => '/models/smartwatch.glb',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category' => 'Home',
                'title' => 'Minimalist Plant Pot',
                'description' => json_encode([
                    [
                        'title' => 'A Touch of Green',
                        'content' => 'This small plant pot brings a bit of nature into my workspace. Taking care of it is a simple habit that helps me stay grounded and connected to something tangible.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 0.0, 'z' => 0.0]],
                        'details' => [
                            ['image' => 'https://tse2.mm.bing.net/th/id/OIP.FV3Mvgw4VezuNh9j4DlYMgHaEo?r=0&rs=1&pid=ImgDetMain&o=7&rm=3', 'text' => 'The small, green leaves.', 'position' => ['x' => 150, 'y' => 20]]
                        ]
                    ],
                    [
                        'title' => 'A Reminder to Grow',
                        'content' => 'It’s a subtle reminder that growth, whether personal or professional, requires consistent care and attention.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 1.0, 'z' => 0.0]],
                        'details' => []
                    ]
                ]),
                'model3d' => '/models/plant-pot.glb',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category' => 'Design',
                'title' => 'Drawing Pen',
                'description' => json_encode([
                    [
                        'title' => 'Precision in My Hand',
                        'content' => 'This is my favorite pen for detailed drawings and wireframing. Its fine tip allows me to capture even the smallest ideas with precision.',
                        'transform' => ['rotation' => ['x' => 0.2, 'y' => -0.5, 'z' => 0.3]],
                        'details' => [
                            ['image' => 'https://tse2.mm.bing.net/th/id/OIP.FV3Mvgw4VezuNh9j4DlYMgHaEo?r=0&rs=1&pid=ImgDetMain&o=7&rm=3', 'text' => 'The ultra-fine tip.', 'position' => ['x' => 50, 'y' => 30], 'pointSize' => 5]
                        ]
                    ],
                    [
                        'title' => 'The Artist’s Touch',
                        'content' => 'A reliable tool that has helped me refine my sketches and bring my design concepts to life on paper.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 2.0, 'z' => 0.0]],
                        'details' => []
                    ],
                    [
                        'title' => 'An Extension of Self',
                        'content' => 'The balance and weight of the pen make it feel like an extension of my hand, allowing for a seamless flow of creativity.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => -1.0, 'z' => 0.0]],
                        'details' => []
                    ]
                ]),
                'model3d' => '/models/drawing-pen.glb',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category' => 'Hobbies',
                'title' => 'Chess Set',
                'description' => json_encode([
                    [
                        'title' => 'Strategy and Patience',
                        'content' => 'This chess set is a recent addition. Playing it helps me practice strategic thinking and patience, skills that are also vital in programming and problem-solving.',
                        'transform' => ['rotation' => ['x' => -0.1, 'y' => 0.5, 'z' => 0.1]],
                        'details' => [
                            ['image' => 'https://tse2.mm.bing.net/th/id/OIP.FV3Mvgw4VezuNh9j4DlYMgHaEo?r=0&rs=1&pid=ImgDetMain&o=7&rm=3', 'text' => 'The intricate pieces.', 'position' => ['x' => 100, 'y' => 50]]
                        ]
                    ],
                    [
                        'title' => 'A Game of Wit',
                        'content' => 'It’s a beautiful challenge that reminds me to always think several steps ahead, both on the board and in my work.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 1.5, 'z' => 0.0]],
                        'details' => []
                    ]
                ]),
                'model3d' => '/models/chess-set.glb',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category' => 'Gadget',
                'title' => 'Digital Camera',
                'description' => json_encode([
                    [
                        'title' => 'My Eye for Detail',
                        'content' => 'This camera is my go-to for capturing the world around me. It helps me train my eye to see details and composition, a skill that translates to design.',
                        'transform' => ['rotation' => ['x' => 0.1, 'y' => 0.2, 'z' => -0.1]],
                        'details' => [
                            ['image' => 'https://tse2.mm.bing.net/th/id/OIP.FV3Mvgw4VezuNh9j4DlYMgHaEo?r=0&rs=1&pid=ImgDetMain&o=7&rm=3', 'text' => 'The high-quality lens.', 'position' => ['x' => 200, 'y' => 50]]
                        ]
                    ],
                    [
                        'title' => 'A Modern Companion',
                        'content' => 'While I appreciate the vintage camera, this digital one offers the convenience and quality needed to capture the world as it is today.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 1.5, 'z' => 0.0]],
                        'details' => []
                    ],
                    [
                        'title' => 'The Moment Captured',
                        'content' => 'Every photo I take is a small piece of my life captured in time. This camera allows me to share my perspective with the world.',
                        'transform' => ['rotation' => ['x' => 0.5, 'y' => 0.0, 'z' => 0.0]],
                        'details' => []
                    ]
                ]),
                'model3d' => '/models/digital-camera.glb',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category' => 'Design',
                'title' => 'Analog Clock',
                'description' => json_encode([
                    [
                        'title' => 'A Timeless Piece',
                        'content' => 'This analog clock is a reminder of the value of time. It’s a simple, elegant object that helps me stay mindful of my schedule without the distractions of a digital device.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 0.0, 'z' => 0.0]],
                        'details' => []
                    ],
                    [
                        'title' => 'Simplicity in Function',
                        'content' => 'In a world of complex gadgets, this clock stands out for its simple purpose and aesthetic appeal. It represents a a preference for quality over complexity.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 1.0, 'z' => 0.0]],
                        'details' => [
                            ['image' => 'https://tse2.mm.bing.net/th/id/OIP.FV3Mvgw4VezuNh9j4DlYMgHaEo?r=0&rs=1&pid=ImgDetMain&o=7&rm=3', 'text' => 'The classic face.', 'position' => ['x' => 50, 'y' => 50]]
                        ]
                    ],
                    [
                        'title' => 'The Subtle Tick',
                        'content' => 'The gentle ticking sound is a calming backdrop to my work, a small rhythmic beat in the quiet of my office.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 2.0, 'z' => 0.0]],
                        'details' => []
                    ]
                ]),
                'model3d' => '/models/analog-clock.glb',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category' => 'Technology',
                'title' => 'Old Radio',
                'description' => json_encode([
                    [
                        'title' => 'The Voice of a Generation',
                        'content' => 'This vintage radio is a reminder of a time when entertainment came through waves. It’s a nostalgic object that connects me to a simpler form of media consumption.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 0.0, 'z' => 0.0]],
                        'details' => []
                    ],
                    [
                        'title' => 'An Inspiration for Sound',
                        'content' => 'It’s a functional object that has a beautiful design. The craftsmanship and attention to detail are a great inspiration for my own work.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 1.5, 'z' => 0.0]],
                        'details' => [
                            ['image' => 'https://tse2.mm.bing.net/th/id/OIP.FV3Mvgw4VezuNh9j4DlYMgHaEo?r=0&rs=1&pid=ImgDetMain&o=7&rm=3', 'text' => 'The tuning dials.', 'position' => ['x' => 200, 'y' => 120]]
                        ]
                    ]
                ]),
                'model3d' => '/models/old-radio.glb',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'category' => 'Home',
                'title' => 'Fountain Pen',
                'description' => json_encode([
                    [
                        'title' => 'The Joy of Writing',
                        'content' => 'This fountain pen is a tool I use for journaling and creative writing. It’s a mindful practice that helps me slow down and focus on my thoughts.',
                        'transform' => ['rotation' => ['x' => -0.3, 'y' => 0.5, 'z' => -0.2]],
                        'details' => [
                            ['image' => 'https://tse2.mm.bing.net/th/id/OIP.FV3Mvgw4VezuNh9j4DlYMgHaEo?r=0&rs=1&pid=ImgDetMain&o=7&rm=3', 'text' => 'The fine nib.', 'position' => ['x' => 50, 'y' => 40]]
                        ]
                    ],
                    [
                        'title' => 'A Personal Touch',
                        'content' => 'Each stroke of the pen is unique, making it a powerful tool for self-expression. It’s a personal item that I cherish.',
                        'transform' => ['rotation' => ['x' => 0.0, 'y' => 2.0, 'z' => 0.0]],
                        'details' => []
                    ]
                ]),
                'model3d' => '/models/fountain-pen.glb',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        DB::table('pieces')->insert($pieces);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pieces');
    }
};
