<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
       Schema::create('media', function (Blueprint $table) {
            $table->id();

            // 1. Kolom Polymorphic Relation (mediable)
            // Digunakan untuk menghubungkan Media ke Model induknya (e.g., Post, User, Work)
            $table->morphs('mediable');

            // 2. Kolom Informasi File
            $table->string('file_name');
            $table->string('file_path'); // Path file di storage
            $table->string('file_type')->nullable(); // Mime type (e.g., image/jpeg)
            $table->unsignedBigInteger('file_size')->nullable(); // Ukuran file dalam bytes

            // 3. Kolom Metadata Kustom (details)
            // Digunakan untuk menyimpan 'row' dan 'order' seperti yang di-update di HasMedia trait
            $table->json('details')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('media');
    }
};
