<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visits', function (Blueprint $table) {
            $table->id();
            $table->string('ip_address')->nullable();
            $table->string('session_id')->nullable(); // Untuk Pengunjung Unik Jangka Pendek
            $table->string('url');
            $table->string('referrer')->nullable();
            $table->string('user_agent', 500)->nullable();
            
            // Kolom untuk Geolokasi (WAJIB disimpan untuk performa dashboard)
            $table->string('country')->nullable(); 
            $table->string('city')->nullable();
            
            $table->timestamps();
                });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visits');
    }
};