@extends('layouts.backend_app')

@section('title', 'Create New Insight')

@section('content')
    <div class="container-fluid">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title fw-semibold mb-4">Create New Insight</h5>
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('backend.insights.store') }}" method="POST">
                            @csrf

                            <div class="mb-3">
                                <label for="title" class="form-label">Title</label>
                                <input type="text" name="title" id="title"
                                    class="form-control @error('title') is-invalid @enderror" value="{{ old('title') }}"
                                    required>
                                @error('title')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="summary" class="form-label">Summary</label>
                                <textarea name="summary" id="summary" rows="5" class="form-control @error('summary') is-invalid @enderror"
                                    required>{{ old('summary') }}</textarea>
                                @error('summary')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="keyword" class="form-label">Keyword (e.g., ai, data, tools)</label>
                                <input type="text" name="keyword" id="keyword"
                                    class="form-control @error('keyword') is-invalid @enderror" value="{{ old('keyword') }}"
                                    required>
                                @error('keyword')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="color" class="form-label">Color (Hex Code, e.g., #804080)</label>
                                <input type="color" name="color" id="color" class="form-control form-control-color"
                                    value="{{ old('color', '#0d6efd') }}">
                                @error('color')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <button type="submit" class="btn btn-primary">Save Insight</button>
                            <a href="{{ route('backend.insights.index') }}"
                                class="btn btn-outline-secondary ms-2">Cancel</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
