@extends('layouts.backend_app')

@section('title', 'Insights Management')

@section('content')
    <div class="container-fluid">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h5 class="card-title fw-semibold">Insights Management</h5>
                    <a href="{{ route('backend.insights.create') }}" class="btn btn-primary">
                        <i class="ti ti-plus"></i> Create New Insight
                    </a>
                </div>

                @if (session('success'))
                    <div class="alert alert-success" role="alert">
                        {{ session('success') }}
                    </div>
                @endif
                @if (session('error'))
                    <div class="alert alert-danger" role="alert">
                        {{ session('error') }}
                    </div>
                @endif

                <div class="card">
                    <div class="card-body p-4">
                        <div class="table-responsive">
                            <table class="table text-nowrap mb-0 align-middle">
                                <thead class="text-dark fs-4">
                                    <tr>
                                        <th class="border-bottom-0" style="width: 5%;">
                                            <h6 class="fw-semibold mb-0">#</h6>
                                        </th>
                                        <th class="border-bottom-0" style="width: 25%;">
                                            <h6 class="fw-semibold mb-0">Title</h6>
                                        </th>
                                        <th class="border-bottom-0" style="width: 40%;">
                                            <h6 class="fw-semibold mb-0">Summary</h6>
                                        </th>
                                        <th class="border-bottom-0" style="width: 15%;">
                                            <h6 class="fw-semibold mb-0">Keyword</h6>
                                        </th>
                                        <th class="border-bottom-0" style="width: 15%;">
                                            <h6 class="fw-semibold mb-0">Actions</h6>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($insights as $insight)
                                        <tr>
                                            <td class="border-bottom-0">
                                                <div
                                                    style="width: 15px; height: 15px; background-color: {{ $insight->color ?? '#343a40' }}; border-radius: 50%; display: inline-block; margin-right: 8px;">
                                                </div>
                                                <h6 class="fw-semibold mb-0 d-inline">{{ $insight->id }}</h6>
                                            </td>
                                            <td class="border-bottom-0">
                                                <h6 class="fw-semibold mb-0">{{ $insight->title }}</h6>
                                            </td>
                                            <td class="border-bottom-0">
                                                <p class="mb-0 fw-normal text-truncate" style="max-width: 300px;">
                                                    {{ $insight->summary }}</p>
                                            </td>
                                            <td class="border-bottom-0">
                                                <span
                                                    class="badge bg-info rounded-3 fw-semibold">{{ $insight->keyword }}</span>
                                            </td>
                                            <td class="border-bottom-0">
                                                <div class="d-flex justify-content-start gap-2">
                                                    <a href="{{ route('backend.insights.edit', $insight->id) }}"
                                                        class="btn btn-sm btn-primary">
                                                        Edit
                                                    </a>
                                                    <form action="{{ route('backend.insights.destroy', $insight->id) }}"
                                                        method="POST"
                                                        onsubmit="return confirm('Are you sure you want to delete this insight?');"
                                                        style="display:inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger">
                                                            Delete
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                @if ($insights->isEmpty())
                    <p class="text-center mt-4">No insights found.</p>
                @endif
            </div>
        </div>
    </div>
@endsection
