@extends('layouts.backend_app')

@section('title', 'Edit Work')

@push('styles')
    {{-- Gaya untuk Bootstrap Tags Input --}}
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.css" />
    <style>
        .bootstrap-tagsinput {
            width: 100%;
        }

        .bootstrap-tagsinput .tag {
            margin-right: 2px;
            color: white;
            background-color: #0d6efd;
            padding: 5px;
            border-radius: 4px;
        }

        /* Gaya untuk media-uploader Anda */
        .media-preview-area {
            display: flex;
            flex-direction: column;
            gap: 15px;
        }

        .media-row {
            min-height: 120px;
            border: 2px dashed #ccc;
            border-radius: 8px;
            padding: 10px;
            background-color: #f8f9fa;
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            align-items: center;
            position: relative;
        }

        /* ... tambahkan gaya media-uploader lainnya jika ada ... */
    </style>
@endpush

@section('content')
    <div class="container-fluid">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title fw-semibold mb-4">Edit Work</h5>
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('backend.works.update', $work->id) }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <div class="mb-3">
                                <label for="title" class="form-label">Title</label>
                                <input type="text" name="title" id="title" class="form-control"
                                    value="{{ $work->title }}" required>
                            </div>

                            <div class="mb-3">
                                <label for="subtitle" class="form-label">Subtitle</label>
                                <input type="text" name="subtitle" id="subtitle" class="form-control"
                                    value="{{ $work->subtitle }}">
                            </div>

                            <div class="mb-3">
                                <label for="description" class="form-label">Description</label>
                                <textarea name="description" id="description" rows="5" class="form-control">{{ $work->description }}</textarea>
                            </div>

                            <div class="mb-3">
                                <label for="tags" class="form-label">Tags</label>
                                <input type="text" name="tags" id="tags" class="form-control"
                                    value="{{ implode(', ', $work->tags ?? []) }}" data-role="tagsinput">
                            </div>

                            <div class="mb-3">
                                <label for="url" class="form-label">URL</label>
                                <input type="url" name="url" id="url" class="form-control"
                                    value="{{ $work->url }}">
                            </div>

                            <x-media-uploader name="media_files" :initialMedia="$work->media" />

                            <button type="submit" class="btn btn-primary">Update Work</button>
                            <a href="{{ route('backend.works.index') }}" class="btn btn-outline-secondary ms-2">Cancel</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    {{-- Pastikan Anda sudah memuat jQuery. Jika belum ada di template utama, tambahkan ini --}}
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    {{-- JavaScript untuk Bootstrap Tags Input --}}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.min.js"></script>
    <script>
        $(document).ready(function() {
            // Inisialisasi plugin Bootstrap Tags Input
            $('#tags').tagsinput({
                confirmKeys: [13, 188] // Tambahkan koma (188) sebagai pemisah
            });

            // Script yang sudah ada untuk media-uploader
            const deletedMediaIdsInput = document.getElementById('deleted_media_ids');
            const removeButtons = document.querySelectorAll('.remove-media');
            let deletedIds = [];

            removeButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const mediaItem = this.closest('.media-item');
                    const mediaId = mediaItem.dataset.id;

                    deletedIds.push(mediaId);
                    deletedMediaIdsInput.value = deletedIds.join(',');

                    mediaItem.remove();
                });
            });
        });
    </script>
@endpush
