@extends('layouts.frontend_app')

@push('styles')
<link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@400;600;700&family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.min.css">

<style>
    /* ------------------------
        GLOBAL (Inherited from Works, adjusted for Labs)
        ------------------------ */
    :root {
        --bg: #ffffff;
        --muted: #6b7280;
        --accent: #5c7cff; /* Warna aksen biru yang lebih 'teknis' */
        --accent-2: #ff915c; /* Warna sekunder oranye/api */
        --card: #fbfbff;
        --dark-hero: #0f0f1d; /* Background hero yang lebih gelap */
    }
    html, body {
        font-family: 'Quicksand', 'Poppins', sans-serif;
        background: var(--bg);
        color: #111827;
        scroll-behavior: smooth;
    }
    section { padding: 64px 20px; }
    .container { max-width: 1150px; margin: 0 auto; }
    a { color: inherit; text-decoration: none; }

    /* ------------------------
        HERO LABS
        ------------------------ */
    .hero-labs {
        position: relative;
        min-height: 50vh;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        overflow: hidden;
        /* Gradien biru tua yang misterius */
        background: linear-gradient(135deg, var(--dark-hero) 0%, #1e2646 100%);
        text-align: center;
    }
    .hero-labs::before {
        content: '';
        position: absolute;
        inset: 0;
        /* Tambahkan efek Grid halus */
        background-image: linear-gradient(0deg, transparent 95%, rgba(255, 255, 255, 0.05) 100%),
                          linear-gradient(90deg, transparent 95%, rgba(255, 255, 255, 0.05) 100%);
        background-size: 20px 20px;
        opacity: 1;
        z-index: 1;
    }
    .hero-labs-inner { position: relative; z-index: 10; max-width: 800px; }
    .hero-labs h1 {
        margin: 0 0 10px 0;
        font-weight: 700;
        font-size: clamp(32px, 5vw, 56px);
        line-height: 1.1;
        letter-spacing: -1px;
    }
    .hero-labs p.lead {
        margin: 0;
        color: #b1b5c0;
        font-size: 1.15rem;
        max-width: 60ch;
        margin: 0 auto;
    }

    /* GSAP Animated Elements for mouse follow (disesuaikan) */
    .parallax-item {
        position: absolute;
        z-index: 5;
        pointer-events: none;
        will-change: transform;
    }
    /* Styling for the animated elements (pure CSS shapes or pseudo-elements) */
    .p-1 { top: 15%; left: 10%; width: 20px; height: 20px; background: var(--accent-2); opacity: 0.8; border-radius: 50%; filter: blur(3px); }
    .p-2 { bottom: 20%; right: 15%; width: 30px; height: 30px; border: 2px solid var(--accent); opacity: 0.6; transform: rotate(45deg); animation: pulse 2s infinite alternate; }
    .p-3 { top: 5%; right: 5%; width: 10px; height: 10px; background: var(--accent); opacity: 0.9; border-radius: 50%; }
    .p-4 { bottom: 10%; left: 5%; width: 50px; height: 4px; background: var(--accent-2); opacity: 0.4; border-radius: 2px; }

    @keyframes pulse {
        from { transform: scale(1) rotate(45deg); opacity: 0.6; }
        to { transform: scale(1.1) rotate(45deg); opacity: 0.8; }
    }


    /* ------------------------
        EXPERIMENTS GRID
        ------------------------ */
    .experiments-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 30px;
        padding-top: 32px;
    }

    .experiment-card {
        background: #fff;
        border-radius: 14px;
        /* Bayangan lebih halus, fokus pada detail */
        box-shadow: 0 8px 20px rgba(15,20,35,0.04);
        border: 1px solid rgba(10,8,20,0.08);
        overflow: hidden;
        display: flex;
        flex-direction: column;
        transition: transform .3s ease, box-shadow .3s ease;
    }

    .experiment-card:hover {
        transform: translateY(-8px);
        /* Bayangan dengan warna aksen Lab */
        box-shadow: 0 16px 40px rgba(92,124,255,0.15), 0 0 0 1px var(--accent); /* border highlight */
    }

    .card-cover {
        height: 200px;
        overflow: hidden;
        background: #eee;
    }

    .card-cover img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.4s ease;
    }
    .experiment-card:hover .card-cover img {
        transform: scale(1.05);
    }

    .card-content {
        padding: 20px;
        flex-grow: 1;
        position: relative;
    }
    .card-content h3 {
        margin: 0 0 6px 0;
        font-size: 1.35rem;
        color: var(--accent);
        line-height: 1.2;
    }
    .card-content h4 {
        margin: 0 0 10px 0;
        font-size: 0.95rem;
        color: #111827;
        font-weight: 600;
        font-style: italic; /* Subtitle dibuat lebih mirip catatan */
    }
    .card-content p {
        color: var(--muted);
        font-size: 0.95rem;
        margin-bottom: 20px;
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
    .card-tags {
        display: flex;
        flex-wrap: wrap;
        gap: 6px;
        margin-top: 12px;
    }
    .card-tags span {
        font-size: 0.75rem;
        font-weight: 600;
        padding: 4px 8px;
        border-radius: 8px;
        /* Warna tag disesuaikan dengan tema Labs */
        background: rgba(92,124,255,0.1);
        color: var(--accent);
        border: 1px solid rgba(92,124,255,0.2);
    }

    /* Button Ikon Detail (Link ke URL) */
    .btn-detail {
        position: absolute;
        bottom: 15px;
        right: 15px;
        width: 38px;
        height: 38px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: var(--accent);
        color: #fff;
        border-radius: 50%;
        font-size: 1.1rem;
        box-shadow: 0 4px 12px rgba(92,124,255,0.4);
        transition: transform 0.2s ease, background 0.2s ease;
    }
    .experiment-card:hover .btn-detail {
        transform: scale(1.1) rotate(5deg);
        background: var(--accent-2); /* Berubah ke warna sekunder saat hover */
    }

    /* Responsive */
    @media (max-width: 768px) {
        .hero-labs { min-height: 35vh; }
        .experiments-grid { grid-template-columns: 1fr; }
        .card-cover { height: 250px; }
    }
</style>
@endpush

@section('content')
<main class="site-main">

    {{-- HERO SECTION: LABS --}}
    <section class="hero-labs" aria-label="Experiments and Labs header">
        <div class="hero-labs-inner">
            <h1 id="heroTitle">The Experimentation Lab</h1>
            <p class="lead" id="heroSubtitle">Where the code gets weird, ideas are stress-tested, and unfinished projects find a home. These are my digital playgrounds.</p>
        </div>

        {{-- GSAP Parallax Items --}}
        <div class="parallax-item p-1" data-depth="0.1"></div>
        <div class="parallax-item p-2" data-depth="0.25"></div>
        <div class="parallax-item p-3" data-depth="0.15"></div>
        <div class="parallax-item p-4" data-depth="0.3"></div>
    </section>

    {{-- EXPERIMENTS LIST --}}
    <section id="labs-list" class="container" aria-label="List of experiments">

        @if ($experiments->isEmpty())
            <div style="text-align:center; padding: 40px; color:var(--muted);">
                <i class="bi bi-cpu" style="font-size: 3rem; color: var(--accent);"></i>
                <h3 style="margin-top:10px;">The lab is quiet...</h3>
                <p>No experiments are running at the moment. Time to hack some code!</p>
            </div>
        @else
            <div class="experiments-grid">
                @foreach ($experiments as $experiment)
                    <div class="experiment-card">
                        {{-- Cover Image --}}
                        <div class="card-cover">
                            <img src="{{ $experiment->cover_path ?? 'https://via.placeholder.com/600x400/5c7cff/ffffff?text=' . urlencode('LAB_' . $experiment->title) }}"
                                 alt="Cover image for {{ $experiment->title }}">
                        </div>

                        {{-- Content --}}
                        <div class="card-content">
                            <h3>{{ $experiment->title }}</h3>
                            <h4>{{ $experiment->subtitle ?? 'Status: In Progress / Prototype' }}</h4>
                            <p>{{ $experiment->description ?? 'A quick peek at the purpose of this experiment. These projects often break or are incomplete, proceed with curiosity.' }}</p>

                            {{-- Tags --}}
                            <div class="card-tags">
                                @if (is_array($experiment->tags))
                                    @foreach ($experiment->tags as $tag)
                                        <span>{{ $tag }}</span>
                                    @endforeach
                                @elseif (!empty($experiment->tags))
                                    {{-- Logika tag handling sama seperti Works --}}
                                    @php
                                        try {
                                            $tags = json_decode($experiment->tags, true);
                                            if (!is_array($tags)) $tags = [$experiment->tags];
                                        } catch (\Exception $e) {
                                            $tags = [trim($experiment->tags, '[]"')];
                                        }
                                        $tags = array_filter($tags);
                                    @endphp

                                    @foreach ($tags as $tag)
                                        @if ($tag)
                                            <span>{{ $tag }}</span>
                                        @endif
                                    @endforeach
                                @endif
                            </div>

                            {{-- Button Detail: Link ke URL (asumsi URL ada) --}}
                            <a href="{{ $experiment->url ?? '#' }}"
                               class="btn-detail"
                               aria-label="View experiment details"
                               target="{{ $experiment->url ? '_blank' : '_self' }}"
                            >
                                <i class="bi bi-box-arrow-up-right"></i>
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
        @endif
    </section>

</main>
<x-floating-ctas />

@endsection

@push('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    gsap.registerPlugin(ScrollTrigger);
    const ease = "power3.out";

    // ------------------------
    // Hero Entrance Animation (Initial Load)
    // ------------------------
    gsap.from("#heroTitle", { y: 20, opacity: 0, duration: 1.2, ease: ease });
    gsap.from("#heroSubtitle", { y: 10, opacity: 0, duration: 1, delay: 0.15, ease: ease });

    // Animate the parallax items fading in
    gsap.from(".parallax-item", { scale: 0.5, opacity: 0, duration: 1.5, stagger: 0.1, ease: "elastic.out(1, 0.7)" });

    // ------------------------
    // Mouse Parallax Effect (Interactive GSAP Hero)
    // ------------------------
    const heroSection = document.querySelector('.hero-labs');
    const parallaxItems = gsap.utils.toArray('.parallax-item');

    if (heroSection && parallaxItems.length > 0) {
        heroSection.addEventListener('mousemove', (e) => {
            const rect = heroSection.getBoundingClientRect();
            const x = (e.clientX - rect.left) / rect.width * 2 - 1;
            const y = (e.clientY - rect.top) / rect.height * 2 - 1;

            parallaxItems.forEach((item) => {
                const depth = parseFloat(item.getAttribute('data-depth')) || 0.1;
                const movementX = x * 25 * depth; // Sensitivitas sedikit lebih tinggi
                const movementY = y * 25 * depth;

                gsap.to(item, {
                    x: movementX,
                    y: movementY,
                    rotation: x * 15 * depth,
                    duration: 1.8, // Smoothing lebih lambat
                    ease: "power2.out"
                });
            });
        });
    }

    // ------------------------
    // Experiment Card Scroll Animation
    // ------------------------
    gsap.utils.toArray('.experiment-card').forEach((card, i) => {
        gsap.from(card, {
            scrollTrigger: {
                trigger: card,
                start: "top 90%",
                toggleActions: "play none none none"
            },
            y: 50,
            opacity: 0,
            duration: 0.8,
            delay: i * 0.1,
            ease: ease
        });
    });

});
</script>
@endpush
