<style>
    /* CSS Khusus untuk Header/Navbar */
    :root {
        --main-text-color: #333;
        --navbar-bg-color: #fff;
        --navbar-border-color: #eee;
        --primary-accent: #E91E63; /* Pink */
        --secondary-accent: #00BCD4; /* Cyan/Mint */
    }

    .navbar {
        background-color: var(--navbar-bg-color);
        border-bottom: 1px solid var(--navbar-border-color);
        transition: all 0.3s ease;
    }
    .navbar-brand img {
        height: 40px;
    }

    /* 1. Kustomisasi Navigasi Tengah */
    .navbar-nav-center {
        width: 100%;
        justify-content: center !important;
        flex-grow: 1;
        margin: 0 auto;
    }

    /* 2. Style untuk Link Navigasi */
    .nav-link {
        color: var(--main-text-color) !important;
        font-weight: bold;
        position: relative;
        transition: all 0.3s ease;
        padding: 10px 15px !important;
    }
    .nav-link::after {
        content: '';
        position: absolute;
        bottom: -5px;
        left: 0;
        width: 0;
        height: 3px;
        background-color: var(--secondary-accent);
        transition: width 0.3s ease;
    }
    .nav-link:hover::after,
    .nav-link.active::after {
        width: 100%;
    }

    /* 3. Style untuk Tombol 'Pieces' (di kanan) */
    .nav-link-button {
        /* Penting: Set display ke inline-block agar padding dan background berfungsi penuh */
        display: inline-block;

        color: white !important;
        background-color: var(--primary-accent); /* Memastikan background ada */
        border: 2px solid var(--primary-accent);
        border-radius: 5px;
        padding: 8px 15px !important;

        /* Menghilangkan margin-left karena tombol sekarang berada di container terpisah */
        /* margin-left: 15px; */

        text-decoration: none !important; /* Hilangkan underline */
        transition: all 0.3s ease;
        text-transform: uppercase;
        font-size: 0.9rem;
        font-weight: 700;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2); /* Shadow yang lebih jelas */
        white-space: nowrap; /* Mencegah teks terpotong jika ada elemen lain di sekitar */
        height: fit-content; /* Memastikan tinggi sesuai konten */
    }
    .nav-link-button:hover {
        background-color: #C2185B; /* Warna lebih gelap saat hover */
        border-color: #C2185B;
        color: white !important;
        opacity: 1; /* Pastikan tidak ada opasitas */
    }
    .nav-link-button::after {
        /* Hapus efek underline link di sini */
        content: none;
    }

    /* Tambahan: Mengatur elemen di kanan agar align vertikal */
    .navbar-nav.right-align {
        display: flex;
        align-items: center; /* Memastikan tombol di tengah secara vertikal */
    }


    /* 4. Penyesuaian Layout Navbar */
    .navbar .container-fluid {
        display: flex;
        justify-content: space-between;
        /* Tambahkan align-items agar semua elemen sejajar vertikal */
        align-items: center;
    }

    /* 5. Mobile (Offcanvas) Styles */
    /* ... (CSS Offcanvas tidak diubah kecuali bagian Pieces) ... */
    .offcanvas-body .nav-link-button {
        /* Di offcanvas, kita bisa kembalikan tombol ke full-width link/button */
        display: block;
        width: 100%;
        margin-top: 15px;
        text-align: center;
        /* Pertahankan style tombolnya di mobile */
        color: white !important;
        background-color: var(--primary-accent);
        border-radius: 5px;
        padding: 10px !important;
    }
</style>

<nav id="mainNavbar" class="navbar navbar-expand-lg fixed-top">
    <div class="container-fluid">
        
        <a class="navbar-brand" href="<?php echo e(route('frontend.home')); ?>">
            <img src="https://static.vecteezy.com/system/resources/previews/020/448/322/non_2x/rnj-letter-logo-design-in-illustration-logo-calligraphy-designs-for-logo-poster-invitation-etc-vector.jpg" alt="Logo RNJ">
        </a>

        
        <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar">
            <span class="navbar-toggler-icon"></span>
        </button>

        
        <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasNavbar" aria-labelledby="offcanvasNavbarLabel">
            <div class="offcanvas-header">
                <h5 class="offcanvas-title" id="offcanvasNavbarLabel">Menu</h5>
                <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
            </div>
            <div class="offcanvas-body">
                
                <ul class="navbar-nav navbar-nav-center d-none d-lg-flex">
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(Route::is('frontend.home') ? 'active' : ''); ?>" href="<?php echo e(route('frontend.home')); ?>">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(Route::is('frontend.works') ? 'active' : ''); ?>" href="<?php echo e(route('frontend.works')); ?>">Works</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(Route::is('frontend.labs') ? 'active' : ''); ?>" href="<?php echo e(route('frontend.labs')); ?>">Labs</a>
                    </li>
                   
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(Route::is('frontend.insights') ? 'active' : ''); ?>" href="<?php echo e(route('frontend.insights')); ?>">Insights</a>
                    </li>
                </ul>

                
                
                <ul class="navbar-nav right-align d-none d-lg-flex">
                    <li class="nav-item">
                        
                        <a class="nav-link-button" href="<?php echo e(route('frontend.pieces.categories')); ?>">
                            Pieces
                        </a>
                    </li>
                </ul>

                
                <ul class="navbar-nav d-lg-none flex-grow-1 pe-3">
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(Route::is('frontend.home') ? 'active' : ''); ?>" href="<?php echo e(route('frontend.home')); ?>">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(Route::is('frontend.works') ? 'active' : ''); ?>" href="<?php echo e(route('frontend.works')); ?>">Works</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(Route::is('frontend.labs') ? 'active' : ''); ?>" href="<?php echo e(route('frontend.labs')); ?>">Labs</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(Route::is('frontend.services') ? 'active' : ''); ?>" href="<?php echo e(route('frontend.services')); ?>">Services</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(Route::is('frontend.insights') ? 'active' : ''); ?>" href="<?php echo e(route('frontend.insights')); ?>">Insights</a>
                    </li>
                    
                    <li class="nav-item">
                        
                        <a class="nav-link-button" href="<?php echo e(route('frontend.pieces.categories')); ?>">Pieces</a>
                    </li>
                </ul>

            </div>
        </div>
    </div>
</nav>
<?php /**PATH C:\Users\rahma\Downloads\RWNJ\RWNJ\resources\views/components/frontend_layouts/header.blade.php ENDPATH**/ ?>