<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.min.css">
<style>
    /* Variabel Warna dari Palet Utama Anda */
    :root {
        --main-bg-color: #f8f8f8;
        --main-text-color: #333;
        --card-bg-color: #fff;
        --card-border-color: #eee;
        --primary-accent: #E91E63; /* Pink */
        --secondary-accent: #00BCD4; /* Cyan/Mint */
    }

    body {
        background-color: var(--main-bg-color);
        color: var(--main-text-color);
    }

    .hero-section {
        background-color: var(--main-bg-color);
        padding: 5rem 0;
        text-align: center;
    }

    .thoughts-section {
        padding: 2rem 0;
    }

    .thought-card {
        border-radius: 10px;
        box-shadow: 0 4px 8px rgba(0,0,0,0.05);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        text-align: left;
    }
    .thought-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 16px rgba(0,0,0,0.1);
    }

    .card-cover {
        height: 200px;
        border-radius: 10px;
        display: flex;
        justify-content: center;
        align-items: center;
        color: #fff; /* Warna teks di dalam kotak */
        font-weight: bold;
        position: relative;
        overflow: hidden; /* Penting untuk efek teks */
    }

    .card-cover .cover-text {
        font-size: 2.5rem;
        text-transform: uppercase;
        position: absolute;
        opacity: 0.5;
        white-space: nowrap; /* Mencegah teks patah baris */
        transition: opacity 0.3s ease, transform 0.3s ease;
    }

    .thought-card:hover .cover-text {
        opacity: 0.7;
        transform: scale(1.05);
    }

    .thought-card-body {
        padding: 1.5rem;
    }

    .thought-card-title {
        font-weight: bold;
        position: relative;
        padding-bottom: 10px;
    }
    .thought-card-title::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 40px;
        height: 3px;
        background-color: var(--secondary-accent);
        border-radius: 2px;
        transition: width 0.3s ease;
    }
    .thought-card:hover .thought-card-title::after {
        width: 100%;
    }

    .read-more-link {
        color: var(--primary-accent);
        font-weight: bold;
        text-decoration: none;
        transition: color 0.3s ease;
    }
    .read-more-link:hover {
        color: var(--secondary-accent);
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    
    <?php
    $thoughts = [
        [
            'title' => 'Generative Tools',
            'summary' => 'Sebuah pemikiran tentang alat-alat generatif dan dampaknya pada kreativitas.',
            'keyword' => 'tools',
            'color' => '#804080', /* Warna ungu */
            'link' => '#thought-detail-1'
        ],
        [
            'title' => 'Curiosity meditations',
            'summary' => 'Menjelajahi konsep rasa ingin tahu dan bagaimana ia membentuk alur kerja kreatif.',
            'keyword' => 'curiosities',
            'color' => '#00a8a8', /* Warna teal/cyan */
            'link' => '#thought-detail-2'
        ],
        [
            'title' => 'Tech optimism vs naivety',
            'summary' => 'Membahas optimisme berlebihan terhadap teknologi dan pentingnya pendekatan yang realistis.',
            'keyword' => 'optimism',
            'color' => '#a0b020', /* Warna hijau limau */
            'link' => '#thought-detail-3'
        ],
        [
            'title' => 'Conversations about AR',
            'summary' => 'Sebuah diskusi tentang augmented reality dan masa depannya.',
            'keyword' => 'augmented reality',
            'color' => '#502050', /* Warna ungu tua */
            'link' => '#thought-detail-4'
        ],
    ];
    ?>

    <div class="hero-section animated-gradient-banner">
        <div class="container">
            <h1>Thoughts</h1>
            <p class="lead">
                A collection of essays, ramblings, and deep dives into the topics of design, technology, and creativity.
            </p>
        </div>
    </div>

    <div class="my-5 container">
        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4">
            <?php $__currentLoopData = $thoughts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $thought): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col d-flex">
                <a href="<?php echo e($thought['link']); ?>" class="thought-card h-100 w-100 text-decoration-none text-dark">
                    
                    <div class="card-cover" style="background-color: <?php echo e($thought['color']); ?>;">
                        <span class="cover-text">
                            <?php echo implode(' ', str_split($thought['keyword'])); ?>
                        </span>
                    </div>

                    
                    <div class="thought-card-body d-flex flex-column">
                        <div>
                            <h5 class="thought-card-title"><?php echo e($thought['title']); ?></h5>
                            <p class="card-text mt-3 text-muted"><?php echo e($thought['summary']); ?></p>
                        </div>
                    </div>
                </a>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.frontend_app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Administrator\Desktop\RWNJ\resources\views/frontend/thoughts.blade.php ENDPATH**/ ?>