<?php $__env->startSection('title', 'Edit Work'); ?>

<?php $__env->startPush('styles'); ?>
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.css" />
    <style>
        .bootstrap-tagsinput {
            width: 100%;
        }
        .bootstrap-tagsinput .tag {
            margin-right: 2px;
            color: white;
            background-color: #0d6efd;
            padding: 5px;
            border-radius: 4px;
        }
        /* Gaya untuk media-uploader Anda */
        .media-preview-area {
            display: flex;
            flex-direction: column;
            gap: 15px;
        }
        .media-row {
            min-height: 120px;
            border: 2px dashed #ccc;
            border-radius: 8px;
            padding: 10px;
            background-color: #f8f9fa;
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            align-items: center;
            position: relative;
        }
        /* ... tambahkan gaya media-uploader lainnya jika ada ... */
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="card">
        <div class="card-body">
            <h5 class="card-title fw-semibold mb-4">Edit Work</h5>
            <div class="card">
                <div class="card-body">
                    <form action="<?php echo e(route('admin.works.update', $work->id)); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <div class="mb-3">
                            <label for="title" class="form-label">Title</label>
                            <input type="text" name="title" id="title" class="form-control" value="<?php echo e($work->title); ?>" required>
                        </div>

                        <div class="mb-3">
                            <label for="subtitle" class="form-label">Subtitle</label>
                            <input type="text" name="subtitle" id="subtitle" class="form-control" value="<?php echo e($work->subtitle); ?>">
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">Description</label>
                            <textarea name="description" id="description" rows="5" class="form-control"><?php echo e($work->description); ?></textarea>
                        </div>

                        <div class="mb-3">
                            <label for="tags" class="form-label">Tags</label>
                            <input type="text" name="tags" id="tags" class="form-control" value="<?php echo e(implode(', ', $work->tags ?? [])); ?>" data-role="tagsinput">
                        </div>

                        <div class="mb-3">
                            <label for="url" class="form-label">URL</label>
                            <input type="url" name="url" id="url" class="form-control" value="<?php echo e($work->url); ?>">
                        </div>

                        <?php if (isset($component)) { $__componentOriginald6bb1fee0d21699991fd4f9665a5ce69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald6bb1fee0d21699991fd4f9665a5ce69 = $attributes; } ?>
<?php $component = App\View\Components\MediaUploader::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('media-uploader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\MediaUploader::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'media_files','initialMedia' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($work->media)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald6bb1fee0d21699991fd4f9665a5ce69)): ?>
<?php $attributes = $__attributesOriginald6bb1fee0d21699991fd4f9665a5ce69; ?>
<?php unset($__attributesOriginald6bb1fee0d21699991fd4f9665a5ce69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald6bb1fee0d21699991fd4f9665a5ce69)): ?>
<?php $component = $__componentOriginald6bb1fee0d21699991fd4f9665a5ce69; ?>
<?php unset($__componentOriginald6bb1fee0d21699991fd4f9665a5ce69); ?>
<?php endif; ?>

                        <button type="submit" class="btn btn-primary">Update Work</button>
                        <a href="<?php echo e(route('admin.works.index')); ?>" class="btn btn-outline-secondary ms-2">Cancel</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.min.js"></script>
    <script>
        $(document).ready(function() {
            // Inisialisasi plugin Bootstrap Tags Input
            $('#tags').tagsinput({
                confirmKeys: [13, 188] // Tambahkan koma (188) sebagai pemisah
            });

            // Script yang sudah ada untuk media-uploader
            const deletedMediaIdsInput = document.getElementById('deleted_media_ids');
            const removeButtons = document.querySelectorAll('.remove-media');
            let deletedIds = [];

            removeButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const mediaItem = this.closest('.media-item');
                    const mediaId = mediaItem.dataset.id;

                    deletedIds.push(mediaId);
                    deletedMediaIdsInput.value = deletedIds.join(',');

                    mediaItem.remove();
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.backend_app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Administrator\Desktop\RWNJ\resources\views/backend/works/edit.blade.php ENDPATH**/ ?>