<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // ------------------------
    // Floating sticky buttons (Ikon + Hover Text Slide)
    // ------------------------
    (function createFloatingButtonsGSAP(){
        const ease = "power2.out";
        const topBtn = document.querySelector('.float-btn.top-btn');

        // Logic ScrollTo Top
        if (topBtn && window.gsap && window.ScrollToPlugin) {
            topBtn.addEventListener('click', () => {
                gsap.to(window, { scrollTo: 0, duration: 0.9, ease: "power2.inOut" });
            });
        }

        // GSAP hover animation
        if (window.gsap) {
            gsap.utils.toArray('.float-btn').forEach(btn => {
                const textEl = btn.querySelector('.float-text');

                // Pastikan elemen teks memiliki posisi awal untuk animasi yang mulus
                gsap.set(textEl, { opacity: 0, x: 10 });

                btn.addEventListener('mouseenter', () => {
                    gsap.to(btn, { scale: 1.08, duration: 0.3, ease });
                    // Animasi teks muncul dari kanan ke kiri
                    gsap.to(textEl, { opacity: 1, x: 0, duration: 0.4, ease });
                });

                btn.addEventListener('mouseleave', () => {
                    gsap.to(btn, { scale: 1, duration: 0.3, ease });
                    // Animasi teks menghilang dari kiri ke kanan (kembali ke posisi awal x: 10)
                    gsap.to(textEl, { opacity: 0, x: 10, duration: 0.3, ease });
                });
            });
        }

        // Accessibility: 't' key scroll top
        document.addEventListener('keydown', (e) => {
            if (e.key === 't' && window.gsap && window.ScrollToPlugin) {
                gsap.to(window, { scrollTo: 0, duration: 0.9, ease: "power2.inOut" });
            }
        });

    })();
});
</script>
<?php $__env->stopPush(); ?>


<div class="floating-buttons" aria-hidden="false">
    <a class="float-btn wa-btn"
        href='https://wa.me/6281234567890?text=<?php echo e(urlencode("Halo Rahma! Saya ingin tahu lebih lanjut tentang proyekmu.")); ?>'
        target='_blank' rel='noopener' title="Chat via WhatsApp">
        <i class="bi bi-whatsapp"></i>
        <span class="float-text">Chat WhatsApp</span>
    </a>

    <a class="float-btn notes-btn"
        href='<?php echo e(route("frontend.insights")); ?>'
        title="Baca Catatan & Refleksi">
        <i class="bi bi-journal-text"></i>
        <span class="float-text">Notes</span>
    </a>

    <button class="float-btn top-btn" type='button' title="Kembali ke Atas">
        <i class="bi bi-arrow-up"></i>
        <span class="float-text">Kembali ke Atas</span>
    </button>
</div>
<?php /**PATH C:\Users\Administrator\Desktop\RWNJ\resources\views/components/frontend_layouts/floating-ctas.blade.php ENDPATH**/ ?>