<?php $__env->startSection('title', 'Pieces Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h5 class="card-title fw-semibold">Pieces Management</h5>
                
                <a href="<?php echo e(route('auth.pieces.create')); ?>" class="btn btn-primary">
                    <i class="ti ti-plus"></i> Create New Piece
                </a>
            </div>

            
            <?php if(session('success')): ?>
                <div class="alert alert-success" role="alert">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-body p-4">
                    <div class="table-responsive">
                        
                        <table class="table text-nowrap mb-0 align-middle">
                            <thead class="text-dark fs-4">
                                <tr>
                                    <th class="border-bottom-0">
                                        <h6 class="fw-semibold mb-0">Title</h6>
                                    </th>
                                    <th class="border-bottom-0">
                                        <h6 class="fw-semibold mb-0">Category</h6>
                                    </th>
                                    <th class="border-bottom-0">
                                        <h6 class="fw-semibold mb-0">3D Model</h6>
                                    </th>
                                  
                                    <th class="border-bottom-0">
                                        <h6 class="fw-semibold mb-0">Actions</h6>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $pieces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $piece): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="border-bottom-0">
                                            <h6 class="fw-semibold mb-0"><?php echo e($piece->title); ?></h6>
                                        </td>
                                        <td class="border-bottom-0">
                                            <span class="badge bg-secondary rounded-3 fw-semibold"><?php echo e($piece->category); ?></span>
                                        </td>
                                        <td class="border-bottom-0">
                                            <p class="mb-0 fw-normal"><?php echo e($piece->model3d ?? 'N/A'); ?></p>
                                        </td>

                                        <td class="border-bottom-0">
                                            <div class="d-flex justify-content-start gap-2">
                                                
                                                <a href="<?php echo e(route('auth.pieces.edit', $piece->id)); ?>" class="btn btn-sm btn-primary">
                                                    Edit
                                                </a>
                                                
                                                <form action="<?php echo e(route('auth.pieces.destroy', $piece->id)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete this piece?');" style="display:inline;">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-sm btn-danger">
                                                        Delete
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend_app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Administrator\Desktop\RWNJ\resources\views/backend/pieces/index.blade.php ENDPATH**/ ?>