<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Canvas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo e(asset('assets/frontend/banner-animation.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.min.css">

    <style>
        /* CSS Global untuk Body dan Konten Utama */
        :root {
            --main-bg-color: #f8f8f8;
            --main-text-color: #333;
        }

        body {
            font-family: 'Helvetica Neue', Arial, sans-serif;
            background-color: var(--main-bg-color);
            color: var(--main-text-color);
            margin: 0;
            /* Padding top akan diatur oleh JavaScript */
        }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>

</head>
<body>

    <?php echo $__env->make('components.frontend_layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="main-content" id="mainContent">
        <?php echo $__env->yieldContent('content'); ?>
    </div>
    
    <?php if(!isset($isFooter) || $isFooter): ?>
        <?php echo $__env->make('components.frontend_layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php endif; ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const navbar = document.getElementById("mainNavbar");
            const mainContent = document.getElementById("mainContent");

            function adjustContentPadding() {
                const navbarHeight = navbar.offsetHeight;
                mainContent.style.marginTop = navbarHeight + "px";
            }

            adjustContentPadding();
            window.addEventListener("resize", adjustContentPadding);
        });
    </script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\Users\Administrator\Desktop\RWNJ\resources\views/layouts/frontend_app.blade.php ENDPATH**/ ?>