<?php $__env->startSection('title', 'Explore 3D Model Archives'); ?>

<?php $__env->startPush('styles'); ?>
<link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@500;700&family=Poppins:wght@300;500;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.min.css">

<style>
    /* Mengadopsi Estetika Modern & Techy */
    :root {
        --primary-bg: #f7f7fc; /* Background lembut, hampir putih */
        --card-bg: #FFFFFF;
        --accent-color: #7c5cff; /* Ungu Utama (dari welcome page) */
        --accent-light: #A18AFF; /* Ungu Pastel untuk header/highlight */
        --text-dark: #1f2937; /* Dark Gray */
        --text-muted: #6b7280; /* Muted Gray */
    }

    .category-page {
        padding: 60px 20px;
        min-height: 80vh;
        display: flex;
        flex-direction: column;
        align-items: center;
        background-color: var(--primary-bg);
        font-family: 'Poppins', 'Quicksand', sans-serif;
        color: var(--text-dark);
    }

    .category-header {
        text-align: center;
        margin-bottom: 60px;
        max-width: 700px;
    }

    .category-header h1 {
        font-size: clamp(2rem, 4vw, 3.2rem);
        font-weight: 700;
        color: var(--accent-color);
        margin-bottom: 15px;
        line-height: 1.1;
        letter-spacing: -0.5px;
    }

    .category-header p {
        font-size: 1.15rem;
        color: var(--text-muted);
        font-weight: 300; /* Lebih tipis untuk filosofi */
    }

    .category-list {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 28px;
        max-width: 1200px;
        width: 100%;
    }

    .category-card {
        background-color: var(--card-bg);
        border-radius: 16px;
        /* Bayangan lebih halus, terinspirasi dari kartu di welcome page */
        box-shadow: 0 8px 20px rgba(124, 92, 255, 0.08); 
        transition: transform 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94), box-shadow 0.3s;
        text-decoration: none;
        color: inherit;
        width: 280px; 
        padding: 30px;
        text-align: center;
        border: 1px solid rgba(124, 92, 255, 0.1);
        display: flex;
        flex-direction: column;
        align-items: center;
    }

    .category-card:hover {
        transform: translateY(-6px);
        box-shadow: 0 15px 35px rgba(124, 92, 255, 0.18);
        border-color: var(--accent-color);
    }

    .category-card h2 {
        margin: 10px 0 4px 0;
        font-size: 1.4rem;
        color: var(--text-dark);
        font-weight: 600;
    }

    .category-icon {
        font-size: 2.5rem;
        color: var(--accent-color);
        background: rgba(124, 92, 255, 0.1); /* Background ikon */
        padding: 12px;
        border-radius: 50%;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        min-width: 50px;
        min-height: 50px;
    }
    
    .category-card small {
        margin-top: 8px;
        color: var(--text-muted);
        font-size: 0.85rem;
    }

    /* Media queries */
    @media (max-width: 768px) {
        .category-header h1 {
            font-size: 2.2rem;
        }
        .category-list {
            gap: 20px;
        }
        .category-card {
            width: 95%;
            max-width: 350px;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="category-page">
    <div class="category-header">
        <h1>Deconstruct The Digital: 3D Archives 🪐</h1>
        <p>A structured index of my computational musings and modeled curiosities. Step into the archives to interact with the raw geometry and explored concepts.</p>
    </div>

    <div class="category-list">
        <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php
                $categorySlug = \Illuminate\Support\Str::slug($category);
                
                // Mapping ikon menggunakan Bootstrap Icons (bi-*) untuk konsistensi visual
                $iconClass = 'bi-box-seam'; // Default
                switch (strtolower($category)) {
                    case 'kata benda':
                        $iconClass = 'bi-book';
                        break;
                    case 'hewan':
                        $iconClass = 'bi-bug';
                        break;
                    case 'tumbuhan':
                        $iconClass = 'bi-tree';
                        break;
                    case 'transportasi':
                        $iconClass = 'bi-truck';
                        break;
                    case 'geometri':
                        $iconClass = 'bi-cone';
                        break;
                    case 'arsitektur':
                        $iconClass = 'bi-building';
                        break;
                }
            ?>
            
            <a href="<?php echo e(route('frontend.pieces.show_by_category', ['category' => $categorySlug])); ?>" class="category-card">
                <span class="category-icon">
                    <i class="bi <?php echo e($iconClass); ?>"></i>
                </span>
                <h2><?php echo e($category); ?></h2>
                <small>Explore the Geometry</small>
            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div style="text-align: center; padding: 50px; color: var(--text-muted);">
                <h2>The Archive is Quiet.</h2>
                <p>No categorised 3D pieces found. Please populate the `pieces` table to activate this exploration module.</p>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend_app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\rahma\Downloads\RWNJ\RWNJ\resources\views/frontend/pieces/list.blade.php ENDPATH**/ ?>