

<footer class="site-footer-v2">
    <div class="container footer-grid">

        
        <div class="footer-col-brand">
            <a class="footer-logo-link" href="<?php echo e(route('frontend.home')); ?>" aria-label="Home">
                
                <span class="footer-logo-text">R.N.J</span>
            </a>
            <p class="tagline">Maker, Tinkerer & Occasional Chaos Artist.</p>
            <p class="copyright-text">&copy; <?php echo e(date('Y')); ?> RNJ. All Rights Reserved.</p>
        </div>

        
        <div class="footer-col-nav">
            <h5 class="footer-heading">Map</h5>
            <ul class="footer-links-list">
                <li><a href="<?php echo e(route('frontend.works')); ?>" class="footer-link">Projects (Works)</a></li>
                <li><a href="<?php echo e(route('frontend.labs')); ?>" class="footer-link">3D Lab (Labs)</a></li>
                <li><a href="<?php echo e(route('frontend.insights')); ?>" class="footer-link">Reflections (Insights)</a></li>
            </ul>
        </div>

        
        <div class="footer-col-connect">
            <h5 class="footer-heading">Connect</h5>
            <div class="social-icons-v2">
                    <?php $__currentLoopData = App\Models\Link::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e($link->url); ?>" target="_blank" rel="noopener" aria-label="<?php echo e($link->name); ?>">
                            <i class="<?php echo e($link->icon ?? 'bi-link-45deg'); ?>"></i> <?php echo e($link->name); ?>

                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



            </div>
        </div>

    </div>
    <div class="footer-bottom">
        
        <p class="built-with-text">Built with Laravel, GSAP, and a lot of <span style="color:#ff7ab6;">coffee</span>.</p>
    </div>
</footer>

<style>
    /* Menggunakan variabel warna dari konteks sebelumnya */
    :root {
        --bg: #ffffff;
        --muted: #6b7280;
        --accent: #7c5cff;
        --accent-2: #ff7ab6; /* Warna sekunder yang lebih lembut/kreatif */
        --dark-hero: #0b1020;
        --text-dark: #111827;
        --border-color: rgba(16,24,40,0.04);
    }

    /* ------------------------
        FOOTER STYLES (v2)
        ------------------------ */
    .site-footer-v2 {
        padding: 40px 20px 0;
        background-color: var(--dark-hero); /* Background gelap agar terasa "techy" */
        color: #d1d5db; /* Teks cerah */
        font-family: 'Quicksand', sans-serif;
    }
    .site-footer-v2 .container {
        max-width: 1150px;
        margin: 0 auto;
    }

    .footer-grid {
        display: grid;
        grid-template-columns: 2fr 1fr 1.5fr; /* Pembagian kolom lebih asimetris */
        gap: 40px;
        padding-bottom: 30px;
        border-bottom: 1px solid rgba(255, 255, 255, 0.08);
    }

    /* Kolom Brand */
    .footer-logo-text {
        font-size: 2.2rem;
        font-weight: 900;
        color: var(--accent);
        letter-spacing: -1px;
        display: block;
        margin-bottom: 8px;
    }
    .tagline {
        color: #9ca3af;
        font-size: 0.95rem;
        margin-top: 0;
    }
    .copyright-text {
        font-size: 0.8rem;
        color: #4b5563;
        margin-top: 15px;
    }

    /* Heading */
    .footer-heading {
        font-size: 1.1rem;
        font-weight: 700;
        margin-top: 0;
        margin-bottom: 12px;
        color: #fff;
        position: relative;
    }
    .footer-heading::after {
        content: '';
        position: absolute;
        bottom: -5px;
        left: 0;
        width: 25px; /* Lebih pendek dari sebelumnya */
        height: 2px;
        background-color: var(--accent-2); /* Menggunakan warna sekunder */
        border-radius: 1px;
    }

    /* Link List */
    .footer-links-list {
        list-style: none;
        padding: 0;
        margin: 0;
        line-height: 1.8;
    }
    .footer-link {
        color: #9ca3af;
        text-decoration: none;
        font-size: 0.9rem;
        transition: color 0.3s ease, transform 0.2s ease;
        display: inline-block;
    }
    .footer-link:hover {
        color: var(--accent);
        transform: translateX(4px); /* Efek slide kecil */
    }

    /* Social Icons */
    .social-icons-v2 {
        display: flex;
        flex-direction: column; /* Ditampilkan secara vertikal */
        gap: 8px;
    }
    .social-icons-v2 a {
        color: #9ca3af;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        font-size: 0.9rem;
        transition: color 0.3s ease, opacity 0.3s ease;
    }
    .social-icons-v2 a i {
        font-size: 1.1rem;
        margin-right: 8px;
        color: var(--accent); /* Ikon berwarna accent */
    }
    .social-icons-v2 a:hover {
        color: #fff;
        opacity: 0.8;
    }

    /* Footer Bottom */
    .footer-bottom {
        text-align: center;
        padding: 15px 0 20px;
    }
    .built-with-text {
        margin: 0;
        font-size: 0.8rem;
        color: #4b5563;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .footer-grid {
            grid-template-columns: 1fr 1fr; /* 2 Kolom di tablet */
            gap: 30px;
        }
        .footer-col-brand {
            grid-column: 1 / -1; /* Branding ambil 1 baris penuh */
            order: -1;
            padding-bottom: 15px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.05);
        }
    }
    @media (max-width: 480px) {
        .footer-grid {
            grid-template-columns: 1fr; /* Stack di mobile */
        }
        .footer-col-brand {
            border-bottom: none;
        }
    }
</style>
<?php /**PATH C:\Users\rahma\Downloads\RWNJ\RWNJ\resources\views/components/frontend_layouts/footer.blade.php ENDPATH**/ ?>